library('plotly')
library('htmlwidgets')
library("paletteer")
library("ggthemes")
# qttEnergyWaterTreatment
# qttTreatedWater
# qualityInletCOD
# qualityOutletCOD
# qualityInletN
# qualityOutletN

sumfun<-function(x,start,end){
  return(sum(x[start:end]))
}

report="qttEnergyWaterTreatment"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]

stages<-c()
for(stage in experiments) {
  stages<-c(stages,rep(stage,12))
}


dataframe <-data.frame(time, report_stage, values)

Energy<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  for (j in c(0:11)) {
    Energy[(i-1)*12+(j+1)]<-sumfun(report_by_stage$values,(j)*30+1,((j+1)*30))
  }
  i=i+1
}


report="qttTreatedWater"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]


dataframe <-data.frame(time, report_stage, values)

TreatedWater<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  j<-1
  TreatedWater[(i-1)*12+(j)]<-report_by_stage$values[(j*30)]
  for (j in c(2:12)) {
    TreatedWater[(i-1)*12+(j)]<-report_by_stage$values[(j*30)]-report_by_stage$values[((j-1)*30)]
  }
  
  #TreatedWater[i]<-sum(report_by_stage$values)
  i=i+1
}



report="qualityInletCOD"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]

#Passem de mg/l a kg/ha/dia 
values<-values*0.1

dataframe <-data.frame(time, report_stage, values)

qualityInletCOD<-c()
aux<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  
  for (j in c(1:12)) {
    qualityInletCOD[(i-1)*12+(j)]<-sumfun(report_by_stage$values,(j-1)*30,(j*30))
  }
  
  i=i+1
}


report="qualityOutletCOD"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]


#Passem de mg/l a kg/ha/dia 
values<-values*0.1

dataframe <-data.frame(time, report_stage, values)

qualityOutletCOD<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  
  for (j in c(1:12)) {
    qualityOutletCOD[(i-1)*12+(j)]<-sumfun(report_by_stage$values,(j-1)*30,(j*30))
  }
  
  i=i+1
}

removedCOD<-qualityInletCOD-qualityOutletCOD
dataframe <- data.frame(Energy,TreatedWater,removedCOD,stages)

fig <- plot_ly(dataframe, x = ~Energy, y = ~TreatedWater, z = ~removedCOD, color=~stages, colors=c("#C7EBB1","#5CC0C0","#699AC2","#2A5783"))
fig <- fig %>% add_markers()
fig <- fig %>% layout(scene = list(xaxis = list(title = 'Energy Consumption (kw)'),
                                   yaxis = list(title = 'Treated Water (m3)'),
                                   zaxis = list(title = 'Removal COD (kg/ha/mes)')))

fig

htmlwidgets::saveWidget(as_widget(fig), "1-NexusCOD.html",selfcontained = FALSE, libdir = "common_libs")



report="qualityInletN"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]


#Passem de mg/l a kg/ha/dia 
values<-values*0.1

dataframe <-data.frame(time, report_stage, values)

qualityInletN<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  
  for (j in c(1:12)) {
    qualityInletN[(i-1)*12+(j)]<-sumfun(report_by_stage$values,(j-1)*30,(j*30))
  }
  
  i=i+1
}


report="qualityOutletN"

values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
report_stage <-report_values$label[report_values$varname == report]


#Passem de mg/l a kg/ha/dia 
values<-values*0.1

dataframe <-data.frame(time, report_stage, values)

qualityOutletN<-c()
i<-1
for (stage in experiments) {
  
  report_by_stage<-dataframe[dataframe$report_stage==stage,]
  
  for (j in c(1:12)) {
    qualityOutletN[(i-1)*12+(j)]<-sumfun(report_by_stage$values,(j-1)*30,(j*30))
  }
  
  i=i+1
}

removedN <-qualityInletN-qualityOutletN

dataframe <- data.frame(Energy,TreatedWater,removedN,stages)
colorsList<-paletteer_c("ggthemes::Green-Blue Diverging", 30)[1:length(stages)]
colorsList<-colorsList[1:4]

fig <- plot_ly(dataframe, x = ~Energy, y = ~TreatedWater, z = ~removedN, color=~stages, colors=c("#C7EBB1","#5CC0C0","#699AC2","#2A5783"))
fig <- fig %>% add_markers()
fig <- fig %>% layout(scene = list(xaxis = list(title = 'Energy Consumption (kw)'),
                                   yaxis = list(title = 'Treated Water (m3)'),
                                   zaxis = list(title = 'Removal N (kg/ha/mes)')))

fig

htmlwidgets::saveWidget(as_widget(fig), "1-NexusN.html",selfcontained = FALSE, libdir = "common_libs")



dataframe <- data.frame(Energy,removedCOD,removedN,stages)
colorsList<-paletteer_c("ggthemes::Green-Blue Diverging", 30)[1:length(stages)]
colorsList<-colorsList[1:4]

fig <- plot_ly(dataframe, x = ~removedN, y = ~removedCOD, z = ~Energy, color=~stages, colors=c("#C7EBB1","#5CC0C0","#699AC2","#2A5783"))
fig <- fig %>% add_markers()
fig <- fig %>% layout(scene = list(xaxis = list(title = 'Removal N (kg/ha/mes)'),
                                   yaxis = list(title = 'Removal COD (kg/ha/mes)'),
                                   zaxis = list(title = 'Energy Consumption (kw)')))

fig

htmlwidgets::saveWidget(as_widget(fig), "1-NVsCODVsEnergy.html",selfcontained = FALSE, libdir = "common_libs")


