#include "CongruentailRandom.h"
#include "bus.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
double factor = 0.25;
char* result_lb = NULL;
char* result_eb = NULL;
char* result = NULL;
double value_lb;
double value_eb;

double max(double x, double y)
{
	if(x > y) {
		return x;
	} else {
		return y;
	}
}

double min(double x, double y)
{
	if(x < y) {
		return x;
	} else {
		return y;
	}
}

void initializeServices(double pax_leave_bus, double pax_enter_bus){

	int i = 0;

	size_t message_len = (sizeof(double)*8 + 2); /* + 1 for terminating NULL */
	result_lb = (char*) malloc(pax_leave_bus*message_len+pax_leave_bus);
	result_eb = (char*) malloc(pax_enter_bus*message_len+pax_enter_bus);
	char* aux = (char*) malloc(message_len);
	double value;
	if (pax_leave_bus==0){
		
		result_lb=NULL;
	} else {
		value_lb = 0;
		value = max(0,normal(0.04,0.012,1));
		sprintf(result_lb, "%e\0", value);
		value_lb += value;
		for(i=1;i<pax_leave_bus;i++){
			value = max(0,normal(0.04,0.012,1));
			sprintf(aux, "%e\0", value);
			strncat(strncat(result_lb, ",\0", 2), aux, message_len);
			value_lb += value;
		}
	}

	if (pax_enter_bus==0){
		result_eb=NULL;
	} else {
		value = max(0,normal(0.07,0.021,1));
		sprintf(aux, "%e\0", value);
		sprintf(result_eb, "%e\0", value);
		value_eb += value;
		for(i=1;i<pax_enter_bus;i++){
			value = max(0,normal(0.07,0.021,1));
			sprintf(aux, "%e\0", value);
			strncat(strncat(result_eb, ",\0", 2), aux, message_len);
			value_eb += value;
		}
	}
	free(aux);
}

/*
* Serial serviceTime
*/
double serviceSerial(double pax_leave_bus, double pax_enter_bus)
{
	return value_lb+value_eb;
}

/*
* Paralel serviceTime
*/
double serviceParalel(double pax_leave_bus, double pax_enter_bus)
{
	return max(value_lb, value_eb);
}

/*
* Serial serviceTime
*/
char* serviceSerialVector(double pax_leave_bus, double pax_enter_bus)
{
	int pos = 0;
	int i;
	result = malloc(pax_leave_bus*sizeof(double)*8+pax_leave_bus+ pax_enter_bus*sizeof(double)*8+pax_enter_bus);
	sprintf(result, "%s\0", result_lb);
	 strncat(strncat(result, ",", 1), result_eb, pax_enter_bus*sizeof(double)*8+pax_enter_bus);
	return result;
}

/*
* Paralel serviceTime
*/
char* serviceParalelVector(double pax_leave_bus, double pax_enter_bus)
{
	if (value_lb==(max(value_lb,value_eb))) return result_lb;
	else return result_eb;
}

/* 
	Els valors que retorna estan calculats previament en la funcio serviceTimeVector
*/
double serviceTime(int serial, double pax_leave_bus, double pax_enter_bus)
{
	if(serial) {
		return serviceSerial(pax_leave_bus, pax_enter_bus);
	} else {
		return serviceParalel(pax_leave_bus, pax_enter_bus);
	}
}
/*
* Calculate the service time 
* serial: 1 for serial, 0 for paralel
* ne: pax in the bus
* ny: pax leaving the bus
*/
char* serviceTimeVector(int serial, double pax_leave_bus, double pax_enter_bus)
{
	initializeServices(pax_leave_bus, pax_enter_bus);
	return result_eb;
	
}

void freeMem(){
	if (result_eb) {
		free(result_eb);
		result_eb = NULL;
	}
	if (result_eb){
		free(result_eb);
		result_eb = NULL;
	}
	if (result){
		free(result);
		result = NULL;
	}
	value_lb = 0;
	value_eb = 0;
}

double dist()
{
	return 1;
}
